;*
;* JAVA CLASS LOADER FOR 6502
;*
	.INCLUDE	"global.inc"
	.INCLUDE	"class.inc"
	.IMPORT	INIT_START,INIT_END
	.IMPORT	PRBYTE,COUT,CROUT,PRNTAX,PRHSTR,PRHSTRLN,PRHEX
	.IMPORT	PUTS,PUTSLN,PRSTR,PRSTRLN,KBWAIT,MEMSRC,MEMDST,MEMCPY,MEMCLR,MUL_FIELDRECSZ,MUL_METHODRECSZ
	.IMPORT	FILE_OPEN,FILE_SETBUFFER,FILE_READ,FILE_CLOSE,PREFIX_GET
	.IMPORT	HMEM_ALLOC,HMEM_ALLOC_CODE,HMEM_ALLOC_FIXED,HMEM_FREE,HMEM_CLR
	.IMPORT	HMEM_PTR,HMEM_LOCK,HMEM_UNLOCK,HMEM_REF_INC,HMEM_REF_DEC
	.IMPORT	HSTR_HASH,STR_HASH,HSTRPL_ADD,HSTRPL_DEL
	.IMPORT	HMEM_DUMP
	.IMPORT	HCLASS_NAME,HCLASS_INDEX,HCLASS_HNDL,HCLASS_ADD,CLASS_STRING
	.IMPORT	CLASS_MATCH_NAME,CLASS_MATCH_DESC,RESOLVE_METHOD,CLASS_METHODPTR
	.IMPORT	ASYNC_STATIC
	.IMPORT	CODECPY,HCODE_ACCESS,HCODE_UNACCESS,HCODE_ALLOC
	.IMPORT	HCODE_ISBYTECODE,HCODE_SETSTACK,HCODE_SETLOCALS,HCODE_SETCLASS,HCODE_SETOFFSET,HCODE_SETHEXCEPT,HCODE_SETEXCEPTLEN
	.IMPORT	THROW_INTERNALERR,THROW_SYSEXCEPTN,CURRENTEXCEPTN
	.EXPORT	LOADCLASS_INIT,LOADCLASS_MEM,LOADCLASS_FILE,CLASSPREFIX
	.EXPORT	HMAINNAMESTR,HMAINDESCSTR,HRUNNAMESTR,HFINALNAMESTR,HVOIDDESCSTR

.MACRO	SWAPAX
	PHA
	TXA
	TAY
	PLA
	TAX
	TYA
.ENDMACRO
	.SEGMENT "INIT"
;*
;* ADD STRING CONSTANTS USED FOR CLASS LOADING INTO STRING POOL.
;* NO ADDITIONAL SPACE WILL BE ALLOCATED FOR MATCHES IN THE CONSTANT POOL.
;*
LOADCLASS_INIT:	LDA	#<CODESTR
	LDX	#>CODESTR
	JSR	HSTRPL_ADD
	STA	HCODESTR
	STX	HCODESTR+1
	LDA	#<CONSTVALSTR
	LDX	#>CONSTVALSTR
	JSR	HSTRPL_ADD
	STA	HCONSTVALSTR
	STX	HCONSTVALSTR+1
	LDA	#<EXCEPTSTR
	LDX	#>EXCEPTSTR
	JSR	HSTRPL_ADD
	STA	HEXCEPTSTR
	STX	HEXCEPTSTR+1
	LDA	#<NATIVESTR
	LDX	#>NATIVESTR
	JSR	HSTRPL_ADD
	STA	HNATIVESTR
	STX	HNATIVESTR+1
	LDA	#<MAINNAMESTR
	LDX	#>MAINNAMESTR
	JSR	HSTRPL_ADD
	STA	HMAINNAMESTR
	STX	HMAINNAMESTR+1
	LDA	#<MAINDESCSTR
	LDX	#>MAINDESCSTR
	JSR	HSTRPL_ADD
	STA	HMAINDESCSTR
	STX	HMAINDESCSTR+1
	LDA	#<INITNAMESTR
	LDX	#>INITNAMESTR
	JSR	HSTRPL_ADD
	STA	HINITNAMESTR
	STX	HINITNAMESTR+1
	LDA	#<RUNNAMESTR
	LDX	#>RUNNAMESTR
	JSR	HSTRPL_ADD
	STA	HRUNNAMESTR
	STX	HRUNNAMESTR+1
	LDA	#<CLINITNAMESTR
	LDX	#>CLINITNAMESTR
	JSR	HSTRPL_ADD
	STA	HCLINITNAMESTR
	STX	HCLINITNAMESTR+1
	LDA	#<FINALNAMESTR
	LDX	#>FINALNAMESTR
	JSR	HSTRPL_ADD
	STA	HFINALNAMESTR
	STX	HFINALNAMESTR+1
	LDA	#<VOIDDESCSTR		; <CLINIT> AND <INIT> SHARE DESC
	LDX	#>VOIDDESCSTR
	JSR	HSTRPL_ADD
	STA	HVOIDDESCSTR
	STX	HVOIDDESCSTR+1
	LDA	#<BOOLSTR		; DATA TYPE STRINGS
	LDX	#>BOOLSTR
	JSR	HSTRPL_ADD
	STA	HBOOLSTR
	STX	HBOOLSTR+1
	LDA	#<BYTESTR
	LDX	#>BYTESTR
	JSR	HSTRPL_ADD
	STA	HBYTESTR
	STX	HBYTESTR+1
	LDA	#<CHARSTR
	LDX	#>CHARSTR
	JSR	HSTRPL_ADD
	STA	HCHARSTR
	STX	HCHARSTR+1
	LDA	#<SHORTSTR
	LDX	#>SHORTSTR
	JSR	HSTRPL_ADD
	STA	HSHORTSTR
	STX	HSHORTSTR+1
	LDA	#<INTSTR
	LDX	#>INTSTR
	JSR	HSTRPL_ADD
	STA	HINTSTR
	STX	HINTSTR+1
	LDA	#<FLOATSTR
	LDX	#>FLOATSTR
	JSR	HSTRPL_ADD
	STA	HFLOATSTR
	STX	HFLOATSTR+1
	LDA	#<LONGSTR
	LDX	#>LONGSTR
	JSR	HSTRPL_ADD
	STA	HLONGSTR
	STX	HLONGSTR+1
	LDA	#<DOUBLESTR
	LDX	#>DOUBLESTR
	JSR	HSTRPL_ADD
	STA	HDOUBLESTR
	STX	HDOUBLESTR+1
	LDA	#<CLASSPREFIX
	LDX	#>CLASSPREFIX
	JSR	PREFIX_GET
.IFDEF	DEBUG_LOAD
	JSR	PUTS
	.ASCIIZ	"CLASS LOAD PATH:"
	LDA	#<CLASSPREFIX
	LDX	#>CLASSPREFIX
	JSR	PRSTRLN
.ENDIF
	LDA	#<LOADCLASS_FILE
	STA	LINK_CLASSLOAD
	LDA	#>LOADCLASS_FILE
	STA	LINK_CLASSLOAD+1
	RTS
	
CODESTR:	.BYTE	4,  "Code"		; CODE ATTRIBUTE
CONSTVALSTR:	.BYTE	13, "ConstantValue"	; CONSTANT VALUE ATTRIBUTE
EXCEPTSTR:	.BYTE	10, "Exceptions"	; EXCEPTIONS ATTRIBUTE
NATIVESTR:	.BYTE	4,  "6502"		; NATIVE 6502 CODE ATTRIBUTE
MAINNAMESTR:	.BYTE	4,  "main"		; MAIN ENRTYPOINT METHOD NAME
MAINDESCSTR:	.BYTE	22, "([Ljava/lang/String;)V"	; MAIN ENTRYPOINT METHOD DESC
RUNNAMESTR:	.BYTE	3,  "run"		; THREAD ENTRYPOINT METHOD NAME
INITNAMESTR:	.BYTE	6,"<init>"		; INSTANCE INIT METHOD
CLINITNAMESTR:	.BYTE	8,"<clinit>"		; CLASS INIT METHOD
FINALNAMESTR:	.BYTE	8,"finalize"		; FINALIZER METHOD
VOIDDESCSTR:	.BYTE	3,"()V"		; VOID METHOD DESC
BOOLSTR:	.BYTE	1,"Z"		; BOOLEAN TYPE
BYTESTR:	.BYTE	1,"B"		; BYTE TYPE
CHARSTR:	.BYTE	1,"C"		; CHARACTER TYPE
SHORTSTR:	.BYTE	1,"S"		; SHORT TYPE
INTSTR:	.BYTE	1,"I"		; INTEGER TYPE
FLOATSTR:	.BYTE	1,"F"		; FLOAT TYPE
LONGSTR:	.BYTE	1,"J"		; LONG TYPE
DOUBLESTR:	.BYTE	1,"D"		; DOUBLE TYPE

	.CODE
CURRENTOFSTPROC: .ADDR	0
READBUFFPROC:	.ADDR	0
RELEASEBUFFPROC: .ADDR	0
CURRENTOFFSET:	JMP	(CURRENTOFSTPROC)
READBUFF:	JMP	(READBUFFPROC)
RELEASEBUFF:	JMP	(RELEASEBUFFPROC)
;*
;* READ FROM FILE INTO BUFFER
;*
READBUFF_MEM:	INC	CLBUFFPTR+1
	RTS
READBUFF_FILE:	LDA	#$00
	LDX	#$01
	JSR	FILE_READ
	CMP	#$00
	BEQ	:+
.IFDEF	DEBUG_LOAD
	JSR	PRBYTE
	PERR	" - ERROR FILE READ, "
.ENDIF
	JMP	READCLASS_ERR
:	INC	CLBUFFPAGE
	RTS
;*
;* RETURN CURRENT READ OFFSET POSITION IN CLASS FILE
;*
;* EXIT: AXY = OFFSET
;*         C = 0 :: VALID OFFSET
;*         C = 1 :: INVALID OFFSET
;*
CURRENTOFST_MEM: SEC
	RTS
CURRENTOFST_FILE: LDA	CLBUFFOFST
	LDX	CLBUFFPAGE
	LDY	#$00
	RTS
;*
;* RELEASE CLASSFILE
;*
RELEASEBUFF_MEM: RTS
RELEASEBUFF_FILE: JSR	FILE_CLOSE
.IFDEF	DEBUG_LOAD
	CMP	#$00
	BEQ	:+
	JSR	PRBYTE
	PERR	" - ERROR CLOSING FILE: "
	JMP	FILECLASS_ERR
:
.ENDIF
	LDA	HCLASSFILEBUFF		; RELEASE FILE BUFFER
	LDX	HCLASSFILEBUFF+1
	JMP	HMEM_FREE
;*
;* READ CLASS DATA FROM FILE BUFFER
;* ONE BYTE VALUE IS RETURNED
;* IN A
;* ENTRY:
;* EXIT:  A = DATA
;*
READBYTE:	LDY	CLBUFFOFST
	LDA	(CLBUFFPTR),Y
	INY
	BNE	:+
	PHA
	JSR	READBUFF
	PLA
	LDY	#$00
:	STY	CLBUFFOFST
	RTS
;*
;* READ CLASS DATA FROM FILE BUFFER
;* TWO BYTE VALUE IS RETURNED
;* IN AX
;* ENTRY:
;* EXIT:  AX = DATA
;*
READWORD:	LDY	CLBUFFOFST
	LDA	(CLBUFFPTR),Y
	INY
	BNE	:+
	PHA
	JSR	READBUFF
	PLA
	LDY	#$00
:	TAX
	LDA	(CLBUFFPTR),Y
	INY
	BNE	:+
	PHA
	TXA
	PHA
	JSR	READBUFF
	PLA
	TAX
	PLA
	LDY	#$00
:	STY	CLBUFFOFST
	RTS
;*
;* READ ATTRIBUTE DATA AND DISCARD
;* 
SKIPATTRIB:	JSR	READWORD
	CPX	#$00
	BNE	SKIPATTRIB_ERR
	CMP	#$00
	BNE	SKIPATTRIB_ERR
	JSR	READWORD
SKIPBYTES:	CLC
	ADC	CLBUFFOFST
	BCC	:+
	INX
:	STA	CLBUFFOFST
	CPX	#$00
	BEQ	SKIPPED
	STX	CCNT
SKIPPAGES:	JSR	READBUFF
	DEC	CCNT
	BNE	SKIPPAGES
SKIPPED:	RTS
SKIPATTRIB_ERR:	JMP	LOADCLASS_ERR
;*
;* READ CLASS STRING DATA FROM MEMORY INTO STRING POOL
;* STRING HANDLE IS RETURNED
;* EXIT:  AX = HANDLE
;*         Y = HASH
;*
READSTRING:	LDA	HREADSTRBUFF
	LDX	HREADSTRBUFF+1
	JSR	HMEM_PTR
	JSR	MEMDST
	JSR	READWORD		; READ STRING LENGTH
	CPX	#$00
	BEQ	:+
	PERR	"STRING TOO LARGE"
	JMP	LOADCLASS_ERR
:	LDY	#$00
	STY	CCNT
	STA	CCNT+1
	STA	(DSTADDR),Y
:	CPY	CCNT+1
	BEQ	ADDSTRING
	JSR	READBYTE
	INC	CCNT
	LDY	CCNT
	STA	(DSTADDR),Y
	BNE	:-
ADDSTRING:	LDA	DSTADDR
	LDX	DSTADDR+1
	JMP	HSTRPL_ADD		; ADD STRING TO POOL
;*
;* READ DATA INTO MEMORY.
;* ENTRY: DSTADDR = ADDRESS OF MEMORY TO READ INTO
;*        AX      = NUMBER OF BYTES TO READ
;*
READMEM:	STA	CCNT
	STX	CCNT+1
	LSR	CCNT+1
	ROR	CCNT
	BCC	:+
	JSR	READBYTE
	LDY	#$00
	STA	(DSTADDR),Y
	INC	DSTADDR
	BNE	:+
	INC	DSTADDR+1
:	LDA	CCNT
	ORA	CCNT+1
	BNE	:+
	RTS
:	INC	CCNT+1
READWORDS:	JSR	READWORD
	LDY	#$01
	STA	(DSTADDR),Y
	DEY
	TXA
	STA	(DSTADDR),Y
	LDA	#$02
	CLC
	ADC	DSTADDR
	STA	DSTADDR
	BCC	:+
	INC	DSTADDR+1
:	DEC	CCNT
	BNE	READWORDS
	DEC	CCNT+1
	BNE	READWORDS
	RTS
;*
;* READ CODE SEGMENT FROM FILE/MEMORY INTO METHOD
;* ENTRY: LDPTR = POINTER TO METHOD RECORD
;* EXIT:  C = 0 :: SUCCESS
;*        C = 1 :: FAILURE
;*
MAXSTACK:	.BYTE	$00
MAXLOCALS:	.BYTE	$00
HCODE:	.BYTE	$00,$00
CODEOFST:	.BYTE	$00,$00,$00
EXCEPTLEN:	.BYTE	$00,$00
HEXCEPT:	.BYTE	$00,$00
READCODE:	JSR	READWORD		; CODE MAX STACK
	CPX	#$00
	BEQ	:+
	PERR	"METHOD STACK OVERFLOW"
	SEC
	RTS
:	STA	MAXSTACK		; SAVE TEMP
	JSR	READWORD		; CODE MAX LOCALS
	CPX	#$00		; MUST BE LESS THAN 256
	BEQ	:+
	PERR	"METHOD LOCALS OVERFLOW"
	SEC
	RTS
:	STA	MAXLOCALS
	JSR	READWORD		; CODE LENH
	CPX	#$00
	BEQ	:+
	CMP	#$00
	BEQ	:+
	PERR	"METHOD CODE SIZE OVERFLOW"
	SEC
	RTS
:	JSR	READWORD		; CODE LENL
	STA	CCNT
	STX	CCNT+1
	LDA	#$00
	STA	CODEOFST		; CLEAR OFFSET
	STA	CODEOFST+1
	STA	CODEOFST+2
	JSR	CURRENTOFFSET		; GET CURRENT FILE OFFSET
	BCS	:+
	STA	CODEOFST
	STX	CODEOFST+1
	STY	CODEOFST+2
:	LDY	#METHODACCESS+1
	LDA	(LDPTR),Y
	AND	#$01		; CHECK FOR NATIVE FLAG
	BEQ	READBYTECODE
	LDA	CCNT
	LDX	CCNT+1
	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOCATE REGULAR MEMORY
	STA	HCODE
	STX	HCODE+1
	JSR	HMEM_PTR
	JSR	MEMDST
	LDA	CCNT
	LDX	CCNT+1
	JSR	READMEM		; COPY CODE FROM FILE BUFFER TO MEMORY BLOCK
	JSR	READWORD		; CODE EXCEPTION COUNT
	CMP	#$00		; MUST BE ZERO FOR NATIVE
	BNE	:+
	CPX	#$00
	BNE	:+
	JMP	READCODE_OK
:	PERR	"EXCEPTS FOR NATIVE NOT ALLOWED"
	SEC
	RTS
READBYTECODE:	LDY	#METHODACCESS
	LDA	(LDPTR),Y
	AND	#$20		; MASK SYNCHRONIZED FLAG
	TAY
	LDA	CCNT
	LDX	CCNT+1
	JSR	HCODE_ALLOC		; ALLOCATE CODE BLOCK
	STA	HCODE
	STX	HCODE+1
	JSR	HCODE_ACCESS		; SET THIS CODE BLOCK AS CURRENTLY ACCESSED
	INC	CCNT+1
COPYCODES:	JSR	READBYTE
	JSR	CODECPY		; COPY CODE INTO CODE BLOCK
	DEC	CCNT
	BNE	COPYCODES
	DEC	CCNT+1
	BNE	COPYCODES
	LDA	MAXSTACK
	JSR	HCODE_SETSTACK
	LDA	MAXLOCALS
	JSR	HCODE_SETLOCALS
	LDA	CODEOFST
	LDX	CODEOFST+1
	LDY	CODEOFST+2
	JSR	HCODE_SETOFFSET
	JSR	READWORD		; CODE EXCEPTION COUNT
	STA	EXCEPTLEN
	STX	EXCEPTLEN+1
	JSR	HCODE_SETEXCEPTLEN
	LDA	EXCEPTLEN
	ASL			; MULTIPLY BY 8 TO GET SIZE
	ROL	EXCEPTLEN+1
	ASL
	ROL	EXCEPTLEN+1
	ASL
	ROL	EXCEPTLEN+1
	STA	EXCEPTLEN
	LDX	EXCEPTLEN+1
	BNE	:+
	CMP	#$00
	BEQ	READCODEUNACC		; ZERO SIZE, SKIP LOAD OF EXCEPTIONS
:	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOCATE EXCEPTION BLOCK
	STA	HEXCEPT
	STX	HEXCEPT+1
	JSR	HMEM_PTR
	JSR	MEMDST
	LDA	EXCEPTLEN
	LDX	EXCEPTLEN+1
	JSR	READMEM		; COPY EXCEPT TABLE FROM FILE BUFFER TO MEMORY BLOCK
	LDA	HEXCEPT
	LDX	HEXCEPT+1
	JSR	HCODE_SETHEXCEPT
READCODEUNACC:	JSR	HCODE_UNACCESS		; CLEAR CURRENT CODE ACCESS
READCODE_OK:	LDY	#METHODSTATICODE	; SAVE ALL HCODE HERE.  MOVE VIRTUAL HCODE LATER
	LDA	HCODE
	STA	(LDPTR),Y
	INY
	LDA	HCODE+1
	STA	(LDPTR),Y
	CLC
	RTS
;*
;* SET CLASS INDEX OF BYTECODE METHOD
;*
SETCODECLASS:	STA	HCODE
	STX	HCODE+1
	JSR	HCODE_ISBYTECODE
	BNE	:+
	LDA	HCODE
	LDX	HCODE+1
	JSR	HCODE_ACCESS		; SET THE CLASS FOR THE CODE
	LDA	ICLASSLD
	JSR	HCODE_SETCLASS
	JSR	HCODE_UNACCESS
:	RTS
;*
;* PRINT STRING FROM TYPE
;*
PRCONSTPL_STR:	JSR	CONSTLD_IDX
.IFDEF	DEBUG_LOAD
	CMP	#$01	; READ UTF8
	BEQ	:+
	PERR	"BAD TYPE IN PRCONSTPL_STR"
	RTS
:
.ENDIF
	JSR	CONSTLD_LOWORD
	JSR	HMEM_PTR
	JMP	PRSTR
;*
;* CALCULATE INDEX INTO CONSTANT POOL AND RETURN TYPE
;* ENTRY: AX = INDEX
;* EXIT:  A  = TYPE
;*
CONSTLD_IDX:	CALC_CONSTPLRECSZ
	CLC			; CALC OFFSET IN CLASS TO CONST POOL
	ADC	#CLASSBASESZ-CONSTPLRECSZ
	BCC	:+
	INX
	CLC
:	ADC	CLASSLDPTR
	STA	CLDPTR
	TXA
	ADC	CLASSLDPTR+1
	STA	CLDPTR+1
.IFDEF	DEBUG_LOAD
	LDY	#$00
	LDA	(CLDPTR),Y
.ENDIF
	RTS
;*
;* RETURN LSW AT CONST POOL INDEX
;* ENTRY: A = TYPE
;* EXIT:  AX = LOWORD
;*
CONSTLD_LOWORD:	LDY	#CONSTPLRECSZ-2
	LDA	(CLDPTR),Y
	INY
	TAX
	LDA	(CLDPTR),Y
	RTS
;*
;* RETURN MSW AT CONST POOL INDEX
;* ENTRY: A = TYPE
;* EXIT:  AX = HIWORD
;*
CONSTLD_HIWORD:	LDY	#CONSTPLRECSZ-4
	LDA	(CLDPTR),Y
	INY
	TAX
	LDA	(CLDPTR),Y
	RTS
;*
;* CLASS FILE READ ERROR.
;*
;*
;* CLASS LOAD ERROR.
;*
LOADCLASS_ERR:
.IFDEF	DEBUG_LOAD
	PERR	"ERROR LOADING CLASS: "
	LDY	#CLASSTHIS+1
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	BEQ	:+
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_PTR
	JSR	PRSTRLN
:
.ENDIF
READCLASS_ERR:
.IFDEF	DEBUG_LOAD
	PERR	"ERROR READING CLASS FILE: "
.ENDIF
	JSR	RELEASEBUFF
	LDA	#7		; CLASS FORMAT
	JMP	THROW_SYSEXCEPTN
FILECLASS_ERR:
.IFDEF	DEBUG_LOAD
	LDA	#<CLASSFILE
	LDX	#>CLASSFILE
	JSR	PRSTRLN
.ENDIF
	LDA	#6		; NO CLASS DEF FOUND
	JMP	THROW_SYSEXCEPTN
;*
;* READ A CLASS FROM A FILE
;* ENTRY: AX = HANDLE TO CLASS NAME
;* EXIT:  AX = HANDLE TO CLASS
;*         Y = CLASS INDEX
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
LOADCLASS_FILE:	JSR	HMEM_PTR
	STA	LDPTR
	STX	LDPTR+1
	LDX	#$00		; COPY CLASS LOAD PREFIX
	LDY	#$01
	LDA	(LDPTR),Y
	AND	#$7F
	CMP	#'/'
	BEQ	:+
COPYCLASSPREFIX: CPX	CLASSPREFIX
	BEQ	:+
	INX
	LDA	CLASSPREFIX,X
	STA	CLASSFILE,X
	BNE	COPYCLASSPREFIX
:	STX	CLASSFILE
	LDY	#$00
	LDA	(LDPTR),Y
	CMP	#16		; CLAMP BASENAME TO 16 CHARACTERS
	BCC	BASENAMEOK
	STA	TMP
	TAY
:	LDA	(LDPTR),Y
	AND	#$7F
	CMP	#'/'		; CHECK FOR DIR SEPARATOR
	BEQ	:+
	DEY
	BNE	:-
:	LDA	TMP
	STY	TMP
	LDY	#$00
	SEC
	SBC	TMP
	CMP	#16
	BCS	:+
	LDA	(LDPTR),Y
	BNE	BASENAMEOK
:	LDA	TMP
	CLC
	ADC	#15
BASENAMEOK:	ADC	CLASSFILE
	STA	CLASSFILE		; SAVE FILENAME LENGTH
COPYCLASSNAME:	INY
	LDA	(LDPTR),Y
	INX
	STA	CLASSFILE,X
	CPX	CLASSFILE
	BNE	COPYCLASSNAME
.IFDEF	DEBUG_LOAD
	.IMPORT	KBWAIT
	PSTR	"LOADING CLASS FILE:"
	LDA	#<CLASSFILE
	LDX	#>CLASSFILE
	JSR	PRSTRLN
	JSR	KBWAIT
.ENDIF
	LDA	#$00		; SIZE OF DATA BUFFER
	LDX	#$01
	LDY	#$00
	JSR	HMEM_ALLOC
	STA	HCLASSFILEBUFF
	STX	HCLASSFILEBUFF+1
	JSR	HMEM_LOCK
	STA	CLBUFFPTR
	STX	CLBUFFPTR+1
	LDA	#<CLASSFILE
	LDX	#>CLASSFILE
	JSR	FILE_OPEN
	CMP	#$00
	BEQ	:+
.IFDEF	DEBUG_LOAD
	JSR	PRBYTE
	PSTR	" - ERROR OPENING FILE: "
.ENDIF
	JMP	FILECLASS_ERR
:	LDY	#$00
	STY	CLBUFFOFST
	STY	CLBUFFPAGE
	LDA	CLBUFFPTR
	LDX	CLBUFFPTR+1
	JSR	FILE_SETBUFFER
	JSR	READBUFF_FILE
	LDA	#<READBUFF_FILE
	STA	READBUFFPROC
	LDA	#>READBUFF_FILE
	STA	READBUFFPROC+1
	LDA	#<CURRENTOFST_FILE
	STA	CURRENTOFSTPROC
	LDA	#>CURRENTOFST_FILE
	STA	CURRENTOFSTPROC+1
	LDA	#<RELEASEBUFF_FILE
	STA	RELEASEBUFFPROC
	LDA	#>RELEASEBUFF_FILE
	STA	RELEASEBUFFPROC+1
	JMP	LOADCLASS_INTERNAL
;*
;* READ A CLASS FROM A MEMORY IMAGE
;* ENTRY: AX = POINTER TO CLASS IMAGE
;*
LOADCLASS_MEM:	STA	CLASSFILEBASE
	STA	CLBUFFPTR
	STX	CLASSFILEBASE+1
	STX	CLBUFFPTR+1
	LDA	#$00
	STA	CLBUFFOFST
	LDA	#<READBUFF_MEM
	STA	READBUFFPROC
	LDA	#>READBUFF_MEM
	STA	READBUFFPROC+1
	LDA	#<CURRENTOFST_MEM
	STA	CURRENTOFSTPROC
	LDA	#>CURRENTOFST_MEM
	STA	CURRENTOFSTPROC+1
	LDA	#<RELEASEBUFF_MEM
	STA	RELEASEBUFFPROC
	LDA	#>RELEASEBUFF_MEM
	STA	RELEASEBUFFPROC+1
;*
;* LOAD A CLASS AND CREATE AN INTERNAL CLASS STRUCTURE
;* CALLED FROM EITHER LOADCLASS_MEM OR LOADCLASS_FILE
;*
LOADCLASS_INTERNAL:
	LDA	#$00
	LDX	#$01
	LDY	#$01
	JSR	HMEM_ALLOC
	STA	HREADSTRBUFF
	STX	HREADSTRBUFF+1		; ALLOC TEMP STRING BUFFER
.IFDEF	DEBUG_LOAD
	PSTR	"MAGIC: "
.ENDIF
	JSR	READWORD		; VERIFY CLASS HEADER
	CMP	#$FE
	BNE	BADMAGIC
	CPX	#$CA
	BNE	BADMAGIC
.IFDEF	DEBUG_LOAD
	SWAPAX
	JSR	PRNTAX
.ENDIF
	JSR	READWORD
	CMP	#$BE
	BNE	BADMAGIC
	CPX	#$BA
	BEQ	:+
BADMAGIC:	PERR	"BAD MAGIC"
	JMP	LOADCLASS_ERR
:
.IFDEF	DEBUG_LOAD
	SWAPAX
	JSR	PRNTAX
	JSR	CROUT
	PSTR	"VERSION: "
.ENDIF
	JSR	READWORD
.IFDEF	DEBUG_LOAD
	SWAPAX
	PHA
	TXA
	PHA
.ENDIF
	JSR	READWORD
.IFDEF	DEBUG_LOAD
	SWAPAX
	JSR	PRNTAX
	LDA	#'.'
	JSR	COUT
	PLA
	TAX
	PLA
	JSR	PRNTAX	
	JSR	CROUT
	PSTR	"CONST POOL COUNT: "
.ENDIF
;*
;* READ CONSTANT POOL
;*
	JSR	READWORD
.IFDEF	DEBUG_LOAD
	STA	LDCNT
	STX	LDCNT+1
	SWAPAX
	JSR	PRNTAX
	JSR	CROUT
	LDA	LDCNT
	LDX	LDCNT+1
.ENDIF
	SEC
	SBC	#$01
	BCS	:+
	DEX
:	STA	LDCNT
	STX	LDCNT+1
	CALC_CONSTPLRECSZ
	CLC			; ADD STATIC CLASS STRUCTURE SIZE
	ADC	#CLASSBASESZ
	BCC	:+
	INX
:	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOCATE CLASS STRUCTURE
	JSR	HMEM_CLR		; CLEAR IT
	STA	HCLASSLD
	STX	HCLASSLD+1
	JSR	HMEM_LOCK		; LOCK CLASS STRUCTURE IN PLACE
	STA	CLASSLDPTR
	STX	CLASSLDPTR+1
	CLC			; CALC OFFSET IN CLASS TO CONST POOL
	ADC	#CLASSBASESZ
	BCC	:+
	INX
:	STA	LDPTR
	STX	LDPTR+1
	LDY	#CLASSCONSTCNT		; SAVE CONST COUNT IN CLASS STRUCTURE
	LDA	LDCNT
	STA	(CLASSLDPTR),Y
	INY
	LDA	LDCNT+1
	STA	(CLASSLDPTR),Y
	INC	LDCNT+1
LOADCONSTPL:	JSR	READBYTE		; READ TYPE
	LDY	#$00
	STA	(LDPTR),Y		; AND STORE IT
	CMP	#CONST_UTF8		; CONST UTF8
	BEQ	LDUTF8
	CMP	#CONST_INTEGER		; CONST INTEGER
	BEQ	LDCONST32
	CMP	#CONST_FLOAT		; CONST FLOAT
	BEQ	LDCONST32
	CMP	#CONST_FIELDREF		; FIELD REF
	BEQ	LDCONST32
	CMP	#CONST_METHDREF		; METHOD REF
	BEQ	LDCONST32
	CMP	#CONST_IFACEMETHDREF	; INTERFACE METHOD REF
	BEQ	LDCONST32
	CMP	#CONST_NAMETYPE		; NAME AND TYPE
	BEQ	LDCONST32
	CMP	#CONST_LONG		; 64 BIT LONG
	BEQ	LDCONST64
	TAX
	LDA	#$00		; STORE NIL IN HIWORD
	LDY	#CONSTPLRECSZ-3
	STA	(LDPTR),Y
	DEY
	STA	(LDPTR),Y
	CPX	#CONST_CLASS		; CLASS
	BEQ	LDCONST16		
	CPX	#CONST_STRING		; STRING OBJECT
	BEQ	LDCONST16		
	PERR	"UNKOWN CONSTANT POOL TYPE"
	JMP	LOADCLASS_ERR
LDUTF8:	LDA	#CL_STR		; CLASS INDEX IN HIWORD
	LDY	#CONSTPLRECSZ-3
	STA	(LDPTR),Y
	JSR	READSTRING
	STY	TMP
	LDY	#CONSTPLRECSZ-1
	STA	(LDPTR),Y		; SAVE HANDLE IN LOWORD
	DEY
	TXA
	STA	(LDPTR),Y
	LDA	TMP
	LDY	#CONSTPLRECSZ-4
	STA	(LDPTR),Y
	JMP	NEXTCONSTPL
LDCONST64:	JSR	READWORD		; SKIP HI 32 BITS
	JSR	READWORD
	LDA	LDPTR
	CLC
	ADC	#CONSTPLRECSZ
	STA	LDPTR
	BCC	:+
	INC	LDPTR+1
:	DEC	LDCNT
LDCONST32:	JSR	READWORD
	LDY	#CONSTPLRECSZ-3
	STA	(LDPTR),Y
	DEY
	TXA
	STA	(LDPTR),Y
LDCONST16:	JSR	READWORD
	LDY	#CONSTPLRECSZ-1
	STA	(LDPTR),Y
	DEY
	TXA
	STA	(LDPTR),Y
NEXTCONSTPL:	LDA	LDPTR
	CLC
	ADC	#CONSTPLRECSZ
	STA	LDPTR
	BCC	:+
	INC	LDPTR+1
:	DEC	LDCNT
	BEQ	:+
	JMP	LOADCONSTPL
:	DEC	LDCNT+1
	BEQ	LOADACCFLGS
	JMP	LOADCONSTPL
;*
;* LOAD ACCESS FLAGS
;*
LOADACCFLGS:	LDA	HREADSTRBUFF
	LDX	HREADSTRBUFF+1
	JSR	HMEM_FREE		; FREE TEMP STRING BUFFER
	JSR	READWORD
	LDY	#CLASSACCESS
	STA	(CLASSLDPTR),Y
	INY
	TXA
	STA	(CLASSLDPTR),Y
;*
;* LOAD CLASS/SUPERCLASS
;*
	JSR	READWORD
	JSR	CONSTLD_IDX
.IFDEF	DEBUG_LOAD
	CMP	#$07		; CHECK FOR CLASS TYPE
	BEQ	:+
	PERR	"BAD CLASS CONST TYPE"
	JMP	LOADCLASS_ERR
:
.ENDIF
	JSR	CONSTLD_LOWORD
	JSR	CONSTLD_IDX
.IFDEF	DEBUG_LOAD
	CMP	#$01		; CHECK FOR UTF8 TYPE
	BEQ	:+
	PERR	"BAD CLASS STR CONST TYPE"
	JMP	LOADCLASS_ERR
:
.ENDIF
	JSR	CONSTLD_LOWORD
	LDY	#CLASSTHIS
	STA	(CLASSLDPTR),Y
	INY
	TXA
	STA	(CLASSLDPTR),Y
	JSR	READWORD		; GET SUPERCLASS
	CMP	#$00
	BNE	:+
	CPX	#$00
	BNE	:+
	BEQ	NOSUPER		; THIS BETTER BE CLASS OBJECT
:	JSR	CONSTLD_IDX
.IFDEF	DEBUG_LOAD
	CMP	#$07
	BEQ	:+
	PERR	"BAD SUPERCLASS CONST TYPE"
	JMP	LOADCLASS_ERR
:
.ENDIF
	JSR	CONSTLD_LOWORD
	JSR	CONSTLD_IDX
.IFDEF	DEBUG_LOAD
	CMP	#$01		; CHECK FOR UTF8 TYPE
	BEQ	:+
	PERR	"BAD SUPERCLASS STR CONST TYPE"
	JMP	LOADCLASS_ERR
:
.ENDIF
	JSR	CONSTLD_LOWORD
NOSUPER:	STA	SUPERCLASS
	STX	SUPERCLASS+1
;*
;* LOAD INTERFACES
;*
	JSR	READWORD
	CPX	#$00 
	BEQ	:+
	PERR	"INTERFACE COUNT > 255"
	JMP	LOADCLASS_ERR
:	LDY	#CLASSIFACECNT
	STA	(CLASSLDPTR),Y
	STA	LDCNT
	CMP	#$00
	BEQ	LOADFIELDCNT
LOADIFACE:	JSR	READWORD
.IFDEF	DEBUG_LOAD
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD		; GET STRING HANDLE
	JSR	PRCONSTPL_STR
.ENDIF
	DEC	LDCNT
	BNE	LOADIFACE
;*
;* LOAD FIELDS
;*
LOADFIELDCNT:	JSR	READWORD
	CPX	#$00
	BEQ	:+
	PERR	"FIELD COUNT > 255"
	JMP	LOADCLASS_ERR
:	LDY	#CLASSFIELDCNT
	STA	(CLASSLDPTR),Y
	STA	LDCNT
	CMP	#$00
	BNE	:+
	JMP	LOADMETHODCNT
:
.IFDEF	DEBUG_LOAD
	PHA
	PSTR	"FIELD COUNT: "
	PLA
	PHA
	JSR	PRBYTE
	JSR	CROUT
	PLA
.ENDIF
	LDX	#$00
	JSR	MUL_FIELDRECSZ		; FIELD RECORD SIZE
	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOC THE FIELD TABLE
	LDY	#CLASSFIELDTBL
	STA	(CLASSLDPTR),Y
	INY
	PHA
	TXA
	STA	(CLASSLDPTR),Y
	PLA
	JSR	HMEM_LOCK		; LOCK FIELD TABLE IN MEMORY
	STA	LDPTR
	STX	LDPTR+1
LOADFIELD:	JSR	READWORD		; ACCESS FLAGS
	LDY	#FIELDACCESS
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	PHA
	JSR	PRBYTE
	LDA	#' '
	JSR	COUT
	PLA
.ENDIF
	JSR	READWORD		; NAME STRING INDEX
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD		; GET STRING HANDLE
	LDY	#FIELDNAME
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	DEY
	LDA	(LDPTR),Y
	JSR	HMEM_PTR
	JSR	PRSTR
	LDA	#' '
	JSR	COUT
.ENDIF
	JSR	READWORD		; DESCRIPTION STRING INDEX
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD		; GET STRING HANDLE
	PHA
	CMP	HBOOLSTR
	BNE	:+
	CPX	HBOOLSTR+1
	BNE	:+
	LDA	#T_BOOLEAN
	BNE	LDFLTYPE
:	CMP	HBYTESTR
	BNE	:+
	CPX	HBYTESTR+1
	BNE	:+
	LDA	#T_BYTE
	BNE	LDFLTYPE
:	CMP	HCHARSTR
	BNE	:+
	CPX	HCHARSTR+1
	BNE	:+
	LDA	#T_CHAR
	BNE	LDFLTYPE
:	CMP	HSHORTSTR
	BNE	:+
	CPX	HSHORTSTR+1
	BNE	:+
	LDA	#T_SHORT
	BNE	LDFLTYPE
:	CMP	HINTSTR
	BNE	:+
	CPX	HINTSTR+1
	BNE	:+
	LDA	#T_INT
	BNE	LDFLTYPE
:	CMP	HFLOATSTR
	BNE	:+
	CPX	HFLOATSTR+1
	BNE	:+
	LDA	#T_FLOAT
	BNE	LDFLTYPE
:	CMP	HLONGSTR
	BNE	:+
	CPX	HLONGSTR+1
	BEQ	BADTYPE
:	CMP	HDOUBLESTR
	BNE	:+
	CPX	HDOUBLESTR+1
	BNE	:+
BADTYPE:	PERR	"UNIMPLEMENTED TYPE"
	JMP	LOADCLASS_ERR
:	LDA	#$80|T_REF
LDFLTYPE:	LDY	#FIELDTYPE
	STA	(LDPTR),Y
	PLA
	LDY	#FIELDDESC
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	DEY
	LDA	(LDPTR),Y
	JSR	HMEM_PTR
	JSR	PRSTR
	LDA	#' '
	JSR	COUT
.ENDIF
	LDY	#FIELDACCESS
	LDA	(LDPTR),Y
	AND	#$08		; CHECK FOR STATIC FIELD
	BEQ	:+
	LDY	#FIELDSTATICVAL		; ZERO OUT STATIC FIELD
	LDA	#$00
	STA	(LDPTR),Y
	INY
	STA	(LDPTR),Y
	INY
	STA	(LDPTR),Y
	INY
	STA	(LDPTR),Y
	BNE	LDFLDATRCNT
:	LDY	#CLASSINSTSIZE+1	; SAVE OFFSET TO INSTANCE FIELD
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	LDY	#FIELDINSTOFFSET
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
	LDY	#FIELDTYPE		; CONVERT TYPE TO SIZE
	LDA	(LDPTR),Y
	AND	#$03		; CLEVERLY MASK SIZE INDEX BITS
	TAY
	LDA	TYPE2SIZE,Y
.IFDEF	DEBUG_LOAD
	BNE	:+
	PERR	"INVALID FIELD SIZE"
	JMP	LOADCLASS_ERR
:
.ENDIF
	LDY	#CLASSINSTSIZE		; INCREMENT INSTANCE SIZE
	CLC
	ADC	(CLASSLDPTR),Y
	STA	(CLASSLDPTR),Y
	BCC	LDFLDATRCNT
	INY
	INX			; X = INSTSIZE (HI)
	TXA
	STA	(CLASSLDPTR),Y
LDFLDATRCNT:	JSR	READWORD		; FIELD ATTRIB COUNT
	CPX	#$00
	BEQ	:+
	PERR	"TOO MANY METHOD ATTRIBUTES"
	JMP	LOADCLASS_ERR
:	CMP	#$00
	BEQ	NEXTFIELD
	STA	ACNT
LDFLDATR:	JSR	READWORD		; FIELD ATTRIB NAME
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD
	CMP	HCONSTVALSTR
	BNE	:+
	CPX	HCONSTVALSTR+1
	BEQ	:++
:	JSR	SKIPATTRIB
	JMP	NEXTFLDATR
:
.IFDEF	DEBUG_LOAD
	JSR	HMEM_PTR
	JSR	PRSTR
.ENDIF
	JSR	READWORD		; FIELD ATTRIB LENL - THIS BETTER BE 2
.IFDEF	DEBUG_LOAD
	CMP	#$02
	BEQ	:+
:	CPX	#$00
	BEQ	:+
	PERR	"BAD CONSTVAL"
	JMP	LOADCLASS_ERR
:	
.ENDIF
	JSR	READWORD		; FIELD ATTRIB LENH
	JSR	READWORD		; FIELD ATTRIB CONST INDEX
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD
	LDY	#FIELDSTATICVAL		; SAVE LOWORD CONSTANTVALUE IN STATIC FIELD 
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
	JSR	CONSTLD_HIWORD
	LDY	#FIELDSTATICVAL+2	; SAVE HIWORD CONSTANTVALUE IN STATIC FIELD 
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	LDA	#' '
	JSR	COUT
	LDY	#FIELDSTATICVAL+2
	LDA	(LDPTR),Y
	INY
	TAX
	LDA	(LDPTR),Y
	JSR	PRNTAX
	LDY	#FIELDSTATICVAL
	LDA	(LDPTR),Y
	INY
	TAX
	LDA	(LDPTR),Y
	JSR	PRNTAX
.ENDIF
NEXTFLDATR:	DEC	ACNT
	BNE	LDFLDATR
NEXTFIELD:
.IFDEF	DEBUG_LOAD
	JSR	CROUT
.ENDIF
	LDA	LDPTR
	CLC
	ADC	#FIELDRECSZ		; NEXT FIELD RECORD
	STA	LDPTR
	BCC	:+
	INC	LDPTR+1
:	DEC	LDCNT
	BEQ	LOADMETHODCNT
	JMP	LOADFIELD
;*
;* LOAD METHODS INTO TABLE.  STATIC METHODS HAVE A CODE HANDLE DIRECTLY IN THE ENTRY, VIRTUAL
;* METHODS HAVE AN OFFSET INTO THE VIRTUAL TABLE TO LOOK UP THE CODE HANDLE
;*
LOADMETHODCNT:	JSR	READWORD
	CPX	#$00
	BEQ	:+
	PERR	"METHOD COUNT > 255"
	JMP	LOADCLASS_ERR
:	LDY	#CLASSMETHODCNT
	STA	(CLASSLDPTR),Y
	STA	LDCNT
	CMP	#$00
	BNE	:+
	JMP	RESOLVESUPER
:
.IFDEF	DEBUG_LOAD
	PHA
	PSTR	"METHOD COUNT: "
	PLA
	PHA
	JSR	PRBYTE
	JSR	CROUT
	PLA
.ENDIF
	LDX	#$00
	JSR	MUL_METHODRECSZ		; 20 BYTES PER FIELD RECORD
	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOC THE METHOD TABLE
	LDY	#CLASSMETHODTBL
	STA	(CLASSLDPTR),Y
	INY
	PHA
	TXA
	STA	(CLASSLDPTR),Y
	PLA
	JSR	HMEM_LOCK		; LOCK METHOD TABLE IN MEMORY
	STA	LDPTR
	STX	LDPTR+1
LOADMETHOD:	JSR	READWORD		; ACCESS FLAGS
	LDY	#METHODACCESS
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	DEY
	LDA	(LDPTR),Y
	SWAPAX
	JSR	PRNTAX
.ENDIF
	JSR	READWORD		; NAME STRING INDEX
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD		; GET STRING HANDLE
	LDY	#METHODNAME
	STA	(LDPTR),Y
	INY
	TXA
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	LDA	#'-'
	JSR	COUT
	LDY	#METHODNAME+1
	LDA	(LDPTR),Y
	DEY
	TAX
	LDA	(LDPTR),Y
	JSR	PRHSTR
	LDA	#' '
	JSR	COUT
.ENDIF
	JSR	READWORD		; DESCRIPTION STRING INDEX
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD		; GET STRING HANDLE
	LDY	#METHODDESC
	STA	(LDPTR),Y
	INY
	PHA
	TXA
	STA	(LDPTR),Y
	PLA
.IFDEF	DEBUG_LOAD
	JSR	PRHSTR
	LDA	#' '
	JSR	COUT
	LDY	#METHODDESC+1
	LDA	(LDPTR),Y
	DEY
	TAX
	LDA	(LDPTR),Y
.ENDIF
	JSR	HMEM_PTR
;
; SCAN DESC STRING FOR PARAMETER COUNT AND RETURN TYPE.
;
SCANPARAMS:	STA	SCANPTR
	STX	SCANPTR+1
	LDX	#$00
	LDY	#$01
.IFDEF	DEBUG_LOAD
	LDA	(SCANPTR),Y
	CMP	#'('		; BETTER START WITH OPENING PAREN
	BEQ	SCANPLP
	PERR	"BAD METHOD DESC STRING - OPENING PAREN"
.ENDIF
SCANPLP:	INY
.IFDEF	DEBUG_LOAD
	BNE	:+
	PERR	"BAD METHD DESC"	; BETTER NOT HAPPEN
	LDX	#$00
	BEQ	SCANP_DONE
:
.ENDIF
	LDA	(SCANPTR),Y
	CMP	#')'		; END OF PARAM LIST
	BEQ	SCANP_DONE
	INX			; INCREMENT PARAM COUNT
SCANPCHK:	CMP	#'L'		; CHECK FOR REFERENCE
	BEQ	SCANPREF
	CMP	#'['		; CHECK FOR ARRAY
	BEQ	SCANPARRAY
;	CMP	#'J'		; CHECK FOR LONG
;	BEQ	:+
;	CMP	#'D'		; CHECK FOR DOUBLE
	BNE	SCANPLP
;:	INX			; LONG/DOUBLE COUNTS AS TWO INT/FLOAT
;	BNE	SCANPLP
SCANPARRAY:	INY			; EAT ARRAY
.IFDEF	DEBUG_LOAD
	BNE	:+
	PERR	"BAD METHD DESC"	; BETTER NOT HAPPEN
	LDX	#$00
	BEQ	SCANP_DONE
:
.ENDIF
	LDA	(SCANPTR),Y
	CMP	#'['		; EAT ARRAY
	BEQ	SCANPARRAY
	CMP	#'L'		; FALL THROUGH FOR ARRAY OBJS
	BNE	SCANPLP
SCANPREF:	INY
.IFDEF	DEBUG_LOAD
	BNE	:+
	PERR	"BAD METHD DESC"	; BETTER NOT HAPPEN
	LDX	#$00
	BEQ	SCANP_DONE
:
.ENDIF
	LDA	(SCANPTR),Y
	CMP	#';'		; CHECK FOR END OF REFERENCE
	BNE	SCANPREF
	BEQ	SCANPLP
SCANP_DONE:	TXA
	ASL			; CONVERT PARAM COUNT TO BYTE COUNT
	ASL			; MULTIPLY BY 4 FOR BYTE COUNT
	LDY	#METHODPARAMS
	STA	(LDPTR),Y
.IFDEF	DEBUG_LOAD
	JSR	PRBYTE
	PSTR	" PARAM BYTES "
.ENDIF
	JSR	READWORD		; METHOD ATTRIB COUNT
	CPX	#$00
	BEQ	:+
	PERR	"TOO MANY METHOD ATTRIBUTES"
	JMP	LOADCLASS_ERR
:	STA	ACNT
	CMP	#$00
	BNE	LDMTHDATR
	JMP	NEXTMETHOD
LDMTHDATR:	JSR	READWORD		; METHOD ATTRIB NAME
	JSR	CONSTLD_IDX
	JSR	CONSTLD_LOWORD
.IFDEF	DEBUG_LOAD
	TAY
	PHA
	TXA
	PHA
	TYA
	JSR	HMEM_PTR
	JSR	PRSTR
	PLA
	TAX
	PLA
.ENDIF
	CMP	HCODESTR
	BNE	:+
	CPX	HCODESTR+1
	BEQ	LDCODE
:	CMP	HNATIVESTR
	BNE	:+
	CPX	HNATIVESTR+1
	BNE	:+
	LDY	#METHODACCESS+1
	LDA	(LDPTR),Y
	AND	#$01		; CHECK FOR NATIVE FLAG
	BNE	LDCODE
	PERR	"MISSING NATIVE ACCESS FLAG FOR 6502 METHOD"
	JMP	LOADCLASS_ERR
:	JSR	SKIPATTRIB
	JMP	NEXTMTHDATR
;*
;* LOAD JAVA BYTECODE/NATIVE 6502
;*
LDCODE:	JSR	READWORD		; CODE ATTRIB LENL
	JSR	READWORD		; CODE ATTRIB LENH
	JSR	READCODE		; READ CODE BLOCK
	BCC	LDCODEATRCNT
	PERR	"ERROR LOADING CODE"
	JMP	LOADCLASS_ERR
LDCODEATRCNT:	JSR	READWORD		; CODE ATTRIB COUNT
	CPX	#$00
	BEQ	:+
	PERR	"TOO MANY CODE ATTRIBS"
	JMP	LOADCLASS_ERR
:	CMP	#$00
	BEQ	NEXTMTHDATR
	STA	ACNT+1
LDCODEATR:	JSR	READWORD		; SKIP ATTRIB NAME
	JSR	SKIPATTRIB		; SKIP ATTRIB DATA
NEXTCODEATR:	DEC	ACNT+1
	BNE	LDCODEATR	
NEXTMTHDATR:	DEC	ACNT
	BEQ	NEXTMETHOD
	JMP	LDMTHDATR
NEXTMETHOD:
.IFDEF	DEBUG_LOAD
	JSR	CROUT
.ENDIF
	LDA	LDPTR
	CLC
	ADC	#METHODRECSZ		; NEXT METHOD RECORD
	STA	LDPTR
	BCC	:+
	INC	LDPTR+1
:	DEC	LDCNT
	BEQ	RESOLVESUPER
	JMP	LOADMETHOD
;*
;* FINISHED LOADING CLASS FILE.  NOW RESOLVE OUTSANDING FIXUPS.
;*
RESOLVESUPER:	JSR	RELEASEBUFF
	LDY	#$00
	LDA	SUPERCLASS		; RESOLVE SUPERCLASS
	LDX	SUPERCLASS+1
	BEQ	ALLDEPENDS
	JSR	HCLASS_NAME
	BCC	ALLDEPENDS		; ALL DEPENDENCIES MET
LOADSUPERCLASS:	LDA	HCLASSLD		; SUPERCLASS NOT FOUND, LOAD IT
	PHA
	LDA	HCLASSLD+1
	PHA
	LDA	SUPERCLASS		; RESOLVE SUPERCLASS
	LDX	SUPERCLASS+1
	JSR	LOADCLASS_FILE		; LOAD THE SUPERCLASS
	BCC	:+
	PERR	"ERROR LOADING SUPERCLASS"
	PLA
	PLA
	SEC
	RTS	
:	JSR	HCLASS_HNDL		; GET INDEX TO SUPERCLASS
	STY	ISUPER
	PLA			; RESTORE HANDLE TO LOADING CLASS
	STA	HCLASSLD+1
	TAX
	PLA
	STA	HCLASSLD
	JSR	HMEM_PTR		; RESTORE POINTER TO LOADING CLASS
	STA	CLASSLDPTR
	STX	CLASSLDPTR+1
	LDY	ISUPER
ALLDEPENDS:	STY	ISUPER
	TYA			; SAVE SUPERCLASS INDEX
	LDY	#CLASSSUPER
	STA	(CLASSLDPTR),Y
	LDA	HCLASSLD		; ADD THIS ALMOST COMPETE CLASS TO DATABASE
	LDX	HCLASSLD+1
	JSR	HCLASS_ADD
	STY	ICLASSLD
;*
;* GET POINTER TO SUPERCLASS AND FIXUP FIELD OFFSETS AND VIRTUAL TABLE ENTRIES
;*
.IFDEF	DEBUG_LOAD
	PSTR	"FIXUP METHOD/VTBL FOR CLASS:"
	LDY	ICLASSLD
	JSR	CLASS_STRING
	JSR	PRHSTRLN
.ENDIF
	LDY	ISUPER
	BNE	:+
	JMP	VTBLINIT
:	JSR	HCLASS_INDEX
	JSR	HMEM_LOCK		; LOCK SUPERCLASS
	STA	SUPERPTR
	STX	SUPERPTR+1
	LDY	#CLASSINSTSIZE		; GET SUPERCLASS' INSTANCE SIZE
	LDA	(SUPERPTR),Y
	INY
	STA	ENTRYOFFSET
	LDA	(SUPERPTR),Y
	STA	ENTRYOFFSET+1		; ADD THIS OFFSET TO INSTANCE SIZE AND FIELD INST OFFSETS
	LDY	#CLASSINSTSIZE		; UPDATE INSTANCE SIZE
	LDA	(CLASSLDPTR),Y
	CLC
	ADC	ENTRYOFFSET
	STA	(CLASSLDPTR),Y
	INY
	LDA	(CLASSLDPTR),Y
	ADC	ENTRYOFFSET+1
	STA	(CLASSLDPTR),Y
	LDY	#CLASSFIELDCNT
	LDA	(CLASSLDPTR),Y
	BEQ	VTBLINIT
	STA	LDCNT
	LDY	#CLASSFIELDTBL+1
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_PTR		; STILL LOCKED FROM EARLIER
	STA	LDPTR
	STX	LDPTR+1
UPDATEFLDLP:	LDY	#FIELDACCESS
	LDA	(LDPTR),Y
	AND	#$08		; CHECK FOR STATIC FIELD
	BNE	UPDATENXTFLD
	LDY	#FIELDINSTOFFSET	; UPDATE FIELD INSTANCE OFFSET
	LDA	(LDPTR),Y
	CLC
	ADC	ENTRYOFFSET
	STA	(LDPTR),Y
	INY
	LDA	(LDPTR),Y
	ADC	ENTRYOFFSET+1
	STA	(LDPTR),Y
UPDATENXTFLD:	LDA	#FIELDRECSZ
	CLC
	ADC	LDPTR
	STA	LDPTR
	BCC	:+
	INC	LDPTR+1
:	DEC	LDCNT
	BNE	UPDATEFLDLP
	LDY	#CLASSFIELDTBL+1	; UNLOCK THE FIELD TABLE
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_UNLOCK
VTBLINIT:	LDA	#$00
	TAX
	LDY	ISUPER
	BEQ	:+
	LDY	#CLASSVTBLCNT
	LDA	(SUPERPTR),Y
:	STA	VCNT		; THIS WILL BE THE ACTUAL VIRT TABLE SIZE
	LDY	#CLASSMETHODCNT		; GET UPPER BOUNDS ON SIZE OF VIRT TABLE
	LDA	(CLASSLDPTR),Y
	STA	LDCNT
	CLC
	ADC	VCNT		; THIS WILL BE ACTUAL VTBL SIZE
	BCC	:+
	LDA	#$FF		; HOPE WE DON'T OVERFLOW
:	STA	ACNT		; KEEP ALLOCATED SIZE AROUND
	ASL
	BCC	:+
	INX
:	LDY	#$01
	JSR	HMEM_ALLOC		; ALLOCATE VIRT TABLE
	LDY	#CLASSVIRTBL
	STA	(CLASSLDPTR),Y
	INY
	PHA
	TXA
	STA	(CLASSLDPTR),Y
	PLA
	JSR	HMEM_LOCK		; LOCK VIRT TABLE
	STA	LDPTR
	STX	LDPTR+1
	JSR	MEMDST
	LDY	ISUPER		; COPY SUPER VTBL INTO THIS VTBL
	BEQ	NOSUPERVTBL
	LDY	#CLASSVIRTBL+1		; GET POINTER TO SUPER VIRT TABLE
	LDA	(SUPERPTR),Y
	DEY
	TAX
	LDA	(SUPERPTR),Y
	JSR	HMEM_PTR
	JSR	MEMSRC
	LDA	VCNT
	LDX	#$00
	ASL
	BCC	:+
	INX
:	JSR	MEMCPY		; COPY IT OVER
NOSUPERVTBL:	LDA	LDCNT
	BNE	:+		; CHECK FOR *THIS* METHODS
	JMP	VTBLDONE		; NO NEW METHODS, SKIP VTBL CHECK
:	LDY	#CLASSMETHODTBL+1	; GET POINTER TO METHODS
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_PTR		; STILL LOCKED FROM EARLIER
	STA	METHODPTR
	STX	METHODPTR+1
VTBLINDXTLP:	LDY	#METHODACCESS		; CHECK FOR STATIC METHODS
	LDA	(METHODPTR),Y
	AND	#$08
	BEQ	VTBLSRCHSUPR
	LDY	#METHODVINDEX+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	SETCODECLASS		; SET CLASS FOR METHOD
	JMP	VTBLINDXNXT
VTBLSRCHSUPR:	LDY	#METHODDESC+1		; LOOK FOR MATCHING METHOD
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	DEY
	JSR	CLASS_MATCH_DESC
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	DEY
	JSR	CLASS_MATCH_NAME
	LDY	ISUPER
	BEQ	VTBLNEWINDX		; NO SUPER, ADD NEW INDEX
	JSR	RESOLVE_METHOD
	BCS	VTBLNEWINDX		; NOT FOUND, ALLOCATE NEW INDEX
	JSR	CLASS_METHODPTR		; FOUND A MATCH, GET ITS INDEX/OFFSET
	STA	TMPTR
	STX	TMPTR+1
	LDY	#METHODVINDEX
	LDA	(TMPTR),Y
	INY
	STA	ENTRYOFFSET
	LDA	(TMPTR),Y
	STA	ENTRYOFFSET+1
.IFDEF	DEBUG_LOAD
	PSTR	"OVERRIDING METHOD:"
	LDY	#METHODNAME+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	LDY	#METHODDESC+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	PSTR	" VTBL INDEX:"
	LDA	ENTRYOFFSET+1
	JSR	PRBYTE
	LDA	ENTRYOFFSET
	JSR	PRBYTE
	JSR	CROUT
;	JSR	KBWAIT
.ENDIF	
	JMP	VTBLINSRTINDX
VTBLNEWINDX:	LDA	VCNT
	LDX	#$00
.IFDEF	DEBUG
	CMP	ACNT
	BCC	:+
	PERR	"OVERFLOWED ALLLOCATED COUNT"
	BRK
:
.ENDIF
	INC	VCNT
	BNE	:+
	PERR	"VIRTUAL TABLE OVERFLOW"
	JMP	THROW_INTERNALERR
:	ASL
	BCC	:+
	INX
:	STA	ENTRYOFFSET
	STX	ENTRYOFFSET+1
.IFDEF	DEBUG_LOAD
	JSR	PUTS
	.ASCIIZ	"ADD METHOD:"
	LDY	#METHODNAME+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	LDY	#METHODDESC+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	PSTR	" VTBL INDEX:"
	LDA	ENTRYOFFSET+1
	JSR	PRBYTE
	LDA	ENTRYOFFSET
	JSR	PRBYTE
	JSR	CROUT
.ENDIF	
VTBLINSRTINDX:	LDY	#METHODVINDEX+1		; UPDATE METHOD ENTRY WITH VTBL INDEX
	LDA	(METHODPTR),Y
	DEY
	TAX
	PHA
	LDA	(METHODPTR),Y
	PHA
	JSR	SETCODECLASS		; SET CLASS OF METHOD
	LDY	#METHODVINDEX
	LDA	ENTRYOFFSET
	STA	(METHODPTR),Y
	INY
	CLC
	ADC	LDPTR		; CALC ADDRESS FOR INDEX
	STA	TMPTR
	LDA	ENTRYOFFSET+1
	STA	(METHODPTR),Y
	ADC	LDPTR+1
	STA	TMPTR+1
	LDY	#$00		; PULL HCODE OFF STACK AND SAVE IN VTBL
	PLA
	STA	(TMPTR),Y
	INY
	PLA
	STA	(TMPTR),Y
VTBLINDXNXT:	LDA	#METHODRECSZ		; NEXT METHOD
	CLC
	ADC	METHODPTR
	STA	METHODPTR
	BCC	:+
	INC	METHODPTR+1
:	DEC	LDCNT
	BEQ	METHDTBLDONE
	JMP	VTBLINDXTLP
METHDTBLDONE:	LDY	#CLASSMETHODTBL+1	; UNLOCK METHOD TABLE
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_UNLOCK
VTBLDONE:	LDY	#CLASSVIRTBL+1		; UNLOCK VIRT TABLE
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_UNLOCK
	LDA	VCNT		; SAVE ACTUAL VTBL SIZE
.IF	0
	CMP	ACNT		; IS IT SMALLER THAN ALLOCATED?
	BEQ	VTBLSIZED
	LDX	#$00
	ASL
	BCC	:+
	INX
:	JSR	HMEM_NEWSIZE
	LDY	#CLASSVIRTBL+1		; RESIZE VIRT TABLE
	LDA	(CLASSLDPTR),Y
	DEY
	TAX
	LDA	(CLASSLDPTR),Y
	JSR	HMEM_RESIZE
	LDA	CCNT
.ENDIF
VTBLSIZED:	LDY	#CLASSVTBLCNT		; SAVE VTBL SIZE
	STA	(CLASSLDPTR),Y
;*
;* UNLOCK THE CLASSES
;*
	LDY	ISUPER
	BEQ	:+
	JSR	HCLASS_INDEX		; UNLOCK SUPERCLASS
	JSR	HMEM_UNLOCK
:	LDA	HCLASSLD
	LDX	HCLASSLD+1
	JSR	HMEM_UNLOCK		; UNLOCK THIS CLASS
	LDA	HCLASSLD		; SAVE CLASS INFO JUST
	PHA			; IN CASE <CLINIT> MESSES IT UP
	LDA	HCLASSLD+1
	PHA
	LDA	ICLASSLD
	PHA
;*
;* LOOK FOR <CLINIT> AND INVOKE IF FOUND
;*
CLINIT:	LDA	HCLINITNAMESTR		; LOOK FOR CLASS INIT
	LDX	HCLINITNAMESTR+1
	JSR	CLASS_MATCH_NAME
	LDA	HVOIDDESCSTR
	LDX	HVOIDDESCSTR+1
	JSR	CLASS_MATCH_DESC
	LDY	ICLASSLD
	JSR	RESOLVE_METHOD
	BCS	CLASSLOADDONE		; NO <CLINIT>
	JSR	ASYNC_STATIC
	BCC	CLASSLOADDONE		; CHECK FOR EXCEPTION
	PLA
	STA	CURRENTEXCEPTN
	PLA
	STA	CURRENTEXCEPTN+1
	PLA
	STA	CURRENTEXCEPTN+2
	PLA
	STA	CURRENTEXCEPTN+3
	SEC
	BCS	:+
CLASSLOADDONE:	CLC
:	PLA			; YIPEE, ALL DONE
	TAY
	PLA
	TAX
	PLA
	RTS
	
	.DATA
CLASSFILEBASE:	.ADDR	$0000
CLASSPREFIX:	.RES	65
CLASSFILE:	.RES	65
HCLASSFILEBUFF:	.WORD	$0000
HCODESTR:	.WORD	$0000		; CODE HANDLE ATTRIBUTE
HCONSTVALSTR:	.WORD	$0000		; CONSTANT VALUE HANDLE ATTRIBUTE
HEXCEPTSTR:	.WORD	$0000		; EXCEPTIONS HANDLE ATTRIBUTE
HNATIVESTR:	.WORD	$0000		; NATIVE 6502 CODE HANDLE ATTRIBUTE
HMAINNAMESTR:	.WORD	$0000		; ENTRYPOINT METHOD NAME
HMAINDESCSTR:	.WORD	$0000		; ENTRYPOINT METHOD DESC
HRUNNAMESTR:	.WORD	$0000		; ENTRYPOINT METHOD NAME
HCLINITNAMESTR:	.WORD	$0000		; CLASS INIT METHOD NAME
HFINALNAMESTR:	.WORD	$0000		; FINALIZER METHOD NAME
HVOIDDESCSTR:	.WORD	$0000		; VOID METHOD DESC
HINITNAMESTR:	.WORD	$0000		; INIT METHOD NAME
HBOOLSTR:	.WORD	$0000
HBYTESTR:	.WORD	$0000
HCHARSTR:	.WORD	$0000
HSHORTSTR:	.WORD	$0000
HINTSTR:	.WORD	$0000
HFLOATSTR:	.WORD	$0000
HLONGSTR:	.WORD	$0000
HDOUBLESTR:	.WORD	$0000
HCLASSLD:	.WORD	$0000		; HANDLE TO CLASS BEING LOADED
ICLASSLD:	.BYTE	$00		; INDEX TO LOADED CLASS IN HCLASS TABLE
SUPERCLASS:	.WORD	$0000		; HSTR TO SUPERCLASS
ISUPER:	.BYTE	$00
ENTRYOFFSET:	.WORD	$0000
HREADSTRBUFF:	.WORD	$0000		; TEMPORARY STRING BUFFER
TYPE2SIZE:	.BYTE	1,2,4,0
